﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MyDownloader.Core;

namespace The.NET_Downloader.Download
{
    public class DownloadItem
    {
        public string Name { get { return System.IO.Path.GetFileNameWithoutExtension(downloader.LocalFile); } }
        public long Size { get { return downloader.FileSize;} }
        public string SizeString
        {
            get
            {
                if (Size < 2048)
                    return Size + "B";
                if (Size < 10240)
                    return (int)(Size / 1024) + "KB";
                return (int)(Size / 1024 / 1024) + "MB";
            }
        }
        public string LocalPath { get { return downloader.LocalFile; }}
        public string RemoteURI { get {return downloader.ResourceLocation.URL;} }
        public bool Active { get { return downloader.IsWorking(); } }
        public int Speed { get { return (int)(downloader.Rate / 1024); } }
        public string TimeRemaining
        {
            get
            {
                if (downloader.Rate < 10)
                    return "A long time";
                return ((int)((downloader.FileSize - downloader.Transfered) / downloader.Rate / 60)) + " minutes";
            }
        }
        public bool StartAutomatically { get; set; }
        public int Progress { get { return (int)downloader.Progress; } }
        public Downloader downloader;

        public Downloader Downloader { get { return downloader; } }

        public DownloadItem(Downloader downloader)
        {
            this.downloader = downloader;
        }

    }
}
